﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace YumeNikkiRandomizer
{
    public class Warp
    {
        public int mapID;
        public int x;
        public int y;
        public int dir;
        public string section;
        public string extraInfo;
        public bool phaseForward;
        
        public Warp(int mapID, int x, int y, int dir, string section = "", bool phaseForward = false)
        {
            this.mapID = mapID;
            this.x = x;
            this.y = y;
            this.dir = dir;
            this.section = section;
            this.phaseForward = phaseForward;
            
            this.extraInfo = "";
            if (section.Equals("Pre-Trip") || section.Equals("Post-Trip") || section.Equals("One-Way Elevator"))
            {
                this.extraInfo = section;
                this.section = "";
            }
        }
        public Warp(int mapID, int x, int y, int dir, bool phaseForward)
        {
            this.mapID = mapID;
            this.x = x;
            this.y = y;
            this.dir = dir;
            this.section = "";
            this.extraInfo = "";
            this.phaseForward = phaseForward;
        }
    }
   
    public class WarpLink
    {
        public string warp1;
        public string warp2;
        
        public WarpLink(string warp1, string warp2)
        {
            this.warp1 = warp1;
            this.warp2 = warp2;
        }
        
        // Randomly picks one of the warp keys and returns it.
        public string getEitherWarpKey()
        {
            return M.random.Next(2) == 0? warp1 : warp2;
        }
        
        // Checks this link to see if it contains the given warp key. If so, it returns the other one; otherwise, it returns an empty string.
        public string getOtherWarpKey(string warp)
        {
            if (warp.Equals(warp1))
                return warp2;
            else if (warp.Equals(warp2))
                return warp1;
            else
                return "";
        }
    }
}
